import React, { Component } from 'react';
import { Text, View } from 'react-native';
class ChildComponent extends Component {
    constructor(props) {
        super(props);
        console.log('ChildComponent: Constructor called:'+ this.props.name);
    }
    componentDidMount() {
        console.log('ChildComponent: componentDidMount called:'+ this.props.name);
    }
    componentDidUpdate(prevProp, prevState) {
        console.log('ChildComponent: componentDidUpdate called:'+ this.props.name);
    }
    componentWillUnmount() {
        console.log('ChildComponent: componentWillUnmount called:'+ this.props.name);
    }
    render() {
        console.log('ChildComponent: render called:'+ this.props.name);
        return (
            <View style={{ justifyContent: 'center', alignItems: 'center' }}>
                <Text style={{ fontSize: 20 }}>Language is: {this.props.name}</Text>
            </View>
        );
    }
}
export default ChildComponent;
